;
;   Conditional Assembly Directives  ****************************************
;
#setnot DEVEL     ;    enable development options to load into Higher Flash
                    ;    (E000 instead of F000) and jump table vectors at
                    ;    DFCD istead of hard vectors at FFDC). You can run
                    ;    new versions in a different area of flash, debugging
                    ;    the new version using an older, more stable version
#setnot SIMULATE     ;    enable simulation situational assembly
#setnot HYPERTERM     ;    enable slow Hyperterminal communications
#set DISASM     ;    Enable disassembly routines. These take a lot of
                    ;    room, and for memory starved applicatiuons, this
                    ;    can free up some flash.
;
;   Microcontroller Peripheral Equates  *************************************
;

#if DEVEL
boot_start      equ $E000               ; start of protected Bootloader
#elseif
boot_start      equ $F000               ; start of protected Bootloader
#endif
flash_protect   equ {(boot_start>7)&$FF} ; Flash Block Protect Reg value
flash_page      equ 128T                 ; Flash Erase Page size
flash_row       equ 64T                  ; Flash Program Row size

init_config1    equ %00000011   ; initial Configuration Register 1
                    ;  Bit_7=0 - LVISTOP - LVI disabled during stop mode
                    ;  Bit_6 unused
                    ;  Bit_5=0 - LVIRSTD - LVI reset enabled during run mode
                    ;  Bit_4=0 - LVIPWRD - Power enabled to LVI module
                    ;  Bit_3=0 - SSREC - Stop recovery after 4096 cycles
                    ;  Bit_2=0 - COPRS - COP rate (2**18 - 2**4)
                    ;  Bit_1=1 - STOP - Stop Instruction disabled
                    ;  Bit_0=1 - COPD - COP Disabled
;
RXBLEN          equ 14T                  ; Serial I/O Receive buffer length
STACK_ALLOC     equ 32T                  ; Monitor Stack Allocation
;
init_scc1       equ %01000000           ; enable SCI, 8-bits, no par, 1 stop
init_scc2       equ %00001100           ; no interupts, rcvr and tmtr enabled
init_scbr       equ %00000011           ; set SCI for 9600 baud
;
; ASCII character definitions

SPACE     equ $20            ; ASCII space
CR        equ $0D            ; ASCII carriage return
LF        equ $0A            ; ASCII linefeed
NUL       equ $00            ; ASCII linefeed
BS        equ $08            ; ASCII Backspace key
XOFF      equ $13            ; ASCII X-Off key (^S or DC3)
XON       equ $11            ; ASCII X-On key (^S or DC1)
ESC       equ $1B            ; ASCII Escape Character
