 ; 68HC908AB32 Equates

PTA    EQU $0000     ; Ports and data direction
PORTA  EQU $0000
PTB    EQU $0001
PORTB  EQU $0001
PTC    EQU $0002
PORTC  EQU $0002
PTD    EQU $0003
PORTD  EQU $0003
DDRA   EQU $0004
DDRB   EQU $0005
DDRC   EQU $0006
DDRD   EQU $0007

PTE    EQU $0008
PORTE  EQU $0008
PTF    EQU $0009
PORTF  EQU $0009
PTG    EQU $000A
PORTG  EQU $000A
PTH    EQU $000B
PORTH  EQU $000B

DDRE   EQU $000C
DDRF   EQU $000D
DDRG   EQU $000E
DDRH   EQU $000F

;*  Serial Peripheral Interface Module (SPI)  ********************************
;*
spcr            equ     $10         ; SPI Control Register
SPRIE           equ     7               ; SPI receiver interrupt enable bit
SPMSTR          equ     5               ; SPI master bit
CPOL            equ     4               ; clock polarity bit
CPHA            equ     3               ; clock phase bit
SPWOM           equ     2               ; SPI wired-or mode bit
SPE             equ     1               ; SPI enable
SPTIE           equ     0               ; SPI transmit interrupt enable
;
spscr           equ     $11         ; SPI Status and Control Register
SPRF            equ     7               ; SPI receiver full bit
ERRIE           equ     6               ; error interrupt enable bit
OVRF            equ     5               ; overflow bit
MODF            equ     4               ; mode fault bit
SPTE            equ     3               ; SPI transmitter empty bit
MODFEN          equ     2               ; mode fault enable bit
SPR1            equ     1               ; SPI baud rate
SPR0            equ     0               ;  select bits
;
spdr            equ     $12         ; SPI Data Register


;*  Serial Communications Interface (SCI)  **********************************
;*
scc1            equ     $13         ; SCI Control Register 1
LOOPS           equ     7               ; loop mode select bit
ENSCI           equ     6               ; enable SCI bit
TXINV           equ     5               ; transmit inversion bit
M               equ     4               ; mode bit
WAKE            equ     3               ; wakeup condition bit
ILTY            equ     2               ; idle line type bit
PEN             equ     1               ; parity enable bit
PTY             equ     0               ; parity bit
;
scc2            equ     $14         ; SCI Control Register 2
SCTIE           equ     7               ; SCI transmit interrupt enable bit
TCIE            equ     6               ; transmission complete int enable bit
SCRIE           equ     5               ; SCI receive interrupt enable bit
ILIE            equ     4               ; idle line interrupt enable bit
TE              equ     3               ; transmitter enable bit
RE              equ     2               ; receiver enable bit
RWU             equ     1               ; receiver wakeup bit
SBK             equ     0               ; send break bit
;
scc3            equ     $15         ; SCI Control Register 3
R8              equ     7               ; received bit 8
T8              equ     6               ; transmitted bit 8
ORIE            equ     3               ; receiver overrun interrupt enable bit
NEIE            equ     2               ; receiver noise error int enable bit
FEIE            equ     1               ; receiver framing error int enable bit
PEIE            equ     0               ; receiver parity error int enable bit
;
scs1            equ     $16         ; SCI Status Register 1
SCTE            equ     7               ; SCI transmitter empty bit
TC              equ     6               ; transmission complete bit
SCRF            equ     5               ; SCI receiver full bit
IDLE            equ     4               ; receiver idle bit
OR              equ     3               ; receiver overrun bit
NF              equ     2               ; receiver noise flag bit
FE              equ     1               ; receiver framing error bit
PE              equ     0               ; receiver parity error bit
;
scs2            equ     $17         ; SCI Status Register 2
BKF             equ     1               ; break flag bit
RPF             equ     0               ; reception in progress flag bit
;
scdr            equ     $18         ; SCI Data Register
scbr            equ     $19         ; SCI Baud Rate Register


;*  External Interrupt (IRQ)  ***********************************************
;*
intscr          equ     $1D         ; IRQ Status and Control Register
IRQF            equ     3               ; IRQ flag bit
ACK             equ     2               ; IRQ interrupt request acknowledge bit
IMASK           equ     1               ; IRQ interrupt mask bit
MODE            equ     0               ; IRQ edge/level select bit

ISCR    EQU $001A


;*  Keyboard Interrupt Module (KBI)  ****************************************
;*
intkbscr        equ     $1B         ; Keyboard Status and Control Register
KBSCR           EQU     $001B
KEYF            equ     3               ; keyboard flag bit
ACKK            equ     2               ; keyboard acknowledge bit
IMASKK          equ     1               ; keyboard interrupt mask bit
MODEK           equ     0               ; keyboard triggering sensitivity bit
;
intkbier        equ     $21         ; Keyboard Interrupt Enable Register
KBICR           EQU     $0021
KBIE4           equ     4
KBIE3           equ     3
KBIE2           equ     2
KBIE1           equ     1
KBIE0           equ     0


;*  Clock Generator Module (CGMC)  ******************************************
;*
pctl            equ     $1C         ; PLL Control Register
PLLIE           equ     7               ; PLL interrupt enable bit
PLLF            equ     6               ; PLL interrupt flag bit
PLLON           equ     5               ; PLL on bit
BCS             equ     4               ; base clock select bit
;
pbwc            equ     $1D         ; PLL Bandwidth Control Register
AUTO            equ     7               ; automatic bandwidth control bit
LOCK            equ     6               ; lock indicator bit
ACQ             equ     5               ; acquisition mode bit

PPG     EQU $001E

;*  Configuration Registers (CONFIG)  ***************************************
;*
CONFIG  EQU $001F    ; System configuration
CONFIG1 EQU $001F
CONFIG2 EQU $003F

TASC    EQU $0020    ; Timer A
TACNTH  EQU $0022
TACNTL  EQU $0023
TAMODH  EQU $0024
TAMODL  EQU $0025
TASC0   EQU $0026
TACH0H  EQU $0027
TACH0L  EQU $0028
TASC1   EQU $0029
TACH1H  EQU $002A
TACH1L  EQU $002B
TASC2   EQU $002C
TACH2H  EQU $002D
TACH2L  EQU $002E
TASC3   EQU $002F
TACH3H  EQU $0030
TACH3L  EQU $0031

TBSC    EQU $0041    ; Timer B
TBCNTH  EQU $0042
TBCNTL  EQU $0043
TBMODH  EQU $0044
TBMODL  EQU $0045
TBSC0   EQU $0046
TBCH0H  EQU $0047
TBCH0L  EQU $0048
TBSC1   EQU $0049
TBCH1H  EQU $004A
TBCH1L  EQU $004B
TBSC2   EQU $0032
TBCH2H  EQU $0033
TBCH2L  EQU $0034
TBSC3   EQU $0035
TBCH3H  EQU $0036
TBCH3L  EQU $0037

TSC     EQU $004B    ; Timer
TCNTH   EQU $004C
TCNTL   EQU $004D
TMODH   EQU $004E
TMODL   EQU $004F



;*  Analog-to-Digital Converter (ADC)  **************************************
;*
adscr           equ     $38         ; ADC Status and Control Register
COCO            equ     7               ; conversions complete flag
AIEN            equ     6               ; ADC interrupt enable bit
ADCO            equ     5               ; ADC continuous conversion bit
ADCH4           equ     4               ; \
ADCH3           equ     3               ;  \
ADCH2           equ     2               ;   ADC channel select bits
ADCH1           equ     1               ;  /
ADCH0           equ     0               ; /
;
adr             equ     $39         ; ADC Data Register
;
adclk           equ     $3A         ; ADC Clock Register
ADIV2           equ     7               ; \
ADIV1           equ     6               ;  ADC clock prescaler bits
ADIV0           equ     5               ; /
ADICLK          equ     4               ; ADC input clock select bit

;* Pullup Registers  **************************************
;*
PTDPUE  EQU $003D
PTFPUE  EQU $003E

;*  System Integration Module (SIM)  ****************************************
;*
sbsr            equ     $FE00       ; SIM Break Status Register
SBSW            equ     1               ; SIM break stop/wait
;
srsr            equ     $FE01       ; SIM Reset Status Register
POR             equ     7               ; power-on reset bit
PIN             equ     6               ; external reset bit
COP             equ     5               ; COP reset bit
ILOP            equ     4               ; illegal opcode reset bit
ILAD            equ     3               ; illegal opcode address reset bit
;MODRST          equ     2               ; monitor mode entry module reset bit
LVI             equ     1               ; LVI reset bit
;
sbfcr           equ     $FE03       ; SIM Break Flag Control Register
BCFE            equ     7               ; break clear flag enable bit

;*  Flash Memory  ***********************************************************
;*
flcr            equ     $FE08       ; Flash Control Register
HVEN            equ     %00001000   ; high-voltage enable bit mask
MASS            equ     %00000100   ; mass erase control bit mask
ERASE           equ     %00000010   ; erase control bit mask
PGM             equ     %00000001   ; program control bit mask
;
flbpr           equ     $FF7E       ; Flash Block Protect Register

;*  Breakpoint Module (BRK)  ************************************************
;*
brkh            equ     $FE0C       ; Break Address Register High
brkl            equ     $FE0D       ; Break Address Register Low
brkscr          equ     $FE0E       ; Break Status and Control Register
BRKE            equ     7               ; break enable bit
BRKA            equ     6               ; break active bit

;*  Low-Voltage Inhibit (LVI)  **********************************************
;*
lvisr           equ     $FE0F       ; LVI Status Register
LVIOUT          equ     7               ; LVI output bit

;* EEprom programming registers  **********************************************
;*
EEDIVHNVR   EQU $fe10
EEDIVLNVR   EQU $fe11
EEDIVH      EQU $fe1a
EEDIVL      EQU $fe1b
EENVR       EQU $fe1c
EECR        EQU $fe1d
EEACR       EQU $fe1f

;*  Computer Operating Properly (COP)  **************************************
;*
copctl          equ     $FFFF       ; COP Control Register

;************************************************************
; VECTORS
;************************************************************

dbg_vectors     equ     $FAD0       ; Debug Vectors

Vectors:        equ $ffd0

ivadc:  equ     $ffd0           ; Vector for A/D conversion Complete
ivkey:  equ     $ffd2           ; Vector for Keyboard
ivsctx: equ     $ffd4           ; Vector for SCI Tx
ivscrx: equ     $ffd6           ; Vector for SCI Rx
ivscer: equ     $ffd8           ; Vector for SCI Error
	equ	$ffda		; Reserved
	equ	$ffdc		; Reserved
ivtb3:	equ	$ffde		; TIMB Channel 3 Vector
ivtb2:	equ	$ffe0		; TIMB Channel 2 Vector
ivsptx: equ     $ffe2           ; Vector for SPI Tx
ivsprx: equ     $ffe4           ; Vector for SPI Rx
ivtbof: equ     $ffe6           ; TIMB Overflow Vector
ivtb1:  equ     $ffe8           ; TIMB Channel 1 Vector
ivtb0:  equ     $ffea           ; TIMB Channel 0 Vector
ivtao:  equ     $ffec           ; TIMA Overflow Vector
ivt1c1: equ     $ffee           ; TIMA Channel 3 Vector
ivta2:  equ     $fff0           ; TIMA Channel 2 Vector
ivta1:  equ     $fff2           ; TIMA Channel 1 Vector
ivta0:  equ     $fff4           ; TIMA Channel 0 Vector
ivtof:  equ     $fff6           ; TIM Overflow Vector
ivpll:  equ     $fff8           ; PLL Vector
ivirq:  equ     $fffa           ; ~IRQ1 Vector
ivswi:  equ     $fffc           ; SWI Vector
ivrst:  equ     $fffe           ; Reset Vector


;************************************************************
;*  Memory Map   ***********************
;************************************************************
;*
ram_start       equ     $0050       ; start of RAM
zpage_end       equ     $00FF       ; End of zero page ram
extraram        equ     $0100       ; Start of Extra RAM
usr_stack       equ     $01ff       ; Bottom of user stack
ram_last        equ     $023F       ; last RAM location
rom_start       equ     $8000       ; start of ROM
rom_last        equ     $FAFF       ; last ROM location  ($FDFF??)


;(C)opywrite P&E Microcomputer Systems, 2000  (www.pemicro.com)
; You may use this code freely as long as this copyright notice
; and website address is included and un-modified.

