;
;   Conditional Assembly Directives  ****************************************
;

#setnot HYPERTERM     ;    enable slow Hyperterminal communications

;
;   Microcontroller Peripheral Equates  *************************************
;

boot_start      equ $E000               ; start of protected Bootloader
flash_protect   equ {(boot_start>7)&$FF} ; Flash Block Protect Reg value
flash_page      equ 128T                 ; Flash Erase Page size

init_config1    equ %00000011   ; initial Configuration Register 1
                    ;  Bit_7=0 - LVISTOP - LVI disabled during stop mode
                    ;  Bit_6 unused
                    ;  Bit_5=0 - LVIRSTD - LVI reset enabled during run mode
                    ;  Bit_4=0 - LVIPWRD - Power enabled to LVI module
                    ;  Bit_3=0 - SSREC - Stop recovery after 4096 cycles
                    ;  Bit_2=0 - COPRS - COP rate (2**18 - 2**4)
                    ;  Bit_1=1 - STOP - Stop Instruction disabled
                    ;  Bit_0=1 - COPD - COP Disabled
;
RXBLEN          equ 14T                  ; Serial I/O Receive buffer length
STACK_ALLOC     equ 32T                  ; Monitor Stack Allocation
;
init_scc1       equ %01000000           ; enable SCI, 8-bits, no par, 1 stop
init_scc2       equ %00001100           ; no interupts, rcvr and tmtr enabled
init_scbr       equ %00000011           ; set SCI for 9600 baud
;
; ASCII character definitions

SPACE     equ $20            ; ASCII space
CR        equ $0D            ; ASCII carriage return
LF        equ $0A            ; ASCII linefeed
NUL       equ $00            ; ASCII linefeed
BS        equ $08            ; ASCII Backspace key
XOFF      equ $13            ; ASCII X-Off key (^S or DC3)
XON       equ $11            ; ASCII X-On key (^S or DC1)
ESC       equ $1B            ; ASCII Escape Character

;-------------------------------------------------------
; TIMING FOR fbus = 0.407 us
;the internal clock fBUS runs at 1/2.4576 ^6 = 0.407 uS.
;The DBNZ instruction takes 3 cycles, which makes 1.22 uS
;us5             EQU     5       ;5 * 1.22 = 6.1 uS
;us10            EQU     9       ;9 * 1.22 = 10.9 uS
;us30            EQU     25      ;25 * 1.22 = 30.5 uS
;us100           EQU     82      ;82 * 1.22 = 100
;ms1             EQU     10      ;10 * 82 * 1.22 = 1.00 mS

;--------------------------------------------------------
; TIMING FOR fbus = 0.115 us
;The DBNZ instruction takes 3 cycles, which makes 0.344 uS
us1             EQU     3       ;3 * 0.344 = 1.032 uS
us5             EQU     18      ;18 * 0.344 = 6.1 uS
us10            EQU     32      ;32 * 0.344 = 10.9 uS
us30            EQU     89      ;89 * 0.344 = 30.5 uS
us50            EQU     148     ;148 * 0.344 = 51 us
ms1             EQU     36      ;36 * 82 * 0.344 = 1.00 mS

tpgs            EQU     us5     ;times taken from MC68HC908AB32/D rev 1
tnvs            EQU     us10
tprog           EQU     us30
tnvh            EQU     us5
terase          EQU     ms1
